# 레디스(Redis)

Key, Value 구조의 비정형 데이터를 저장하고 관리하기 위한 오픈 소스 기반의 비관계형 데이터베이스 관리 시스템 (DBMS)이다.  
데이터베이스, 캐시, 메시지 브로커로 사용되며 인메모리 데이터 구조를 가진 저장소이다.

### 데이터베이스가 있는데도 Redis를 사용하는 이유가 뭘까?

데이터베이스는 데이터를 물리 디스크에 직접 쓰기 때문에 서버에 문제가 발생하여 다운되더라도 데이터가 손실되지 않는다. 하지만 매번 디스크에 접근해야 하기 때문에 사용자가 많아질수록 부하가 많아져서 느려질 수 있고, 일반적으로 서비스 운영 초반이거나 규모가 작은, 사용자가 많지 않은 서비스의 경우에는 WEB - WAS - DB 의 구조로도 데이터 베이스에 무리가 가지 않는다.  
<img width="755" alt="스크린샷 2023-01-11 오후 6 15 23" src="https://user-images.githubusercontent.com/70997596/211776589-92936b02-d0bc-45d4-a049-de86bd4b78cf.png">


하지만 사용자가 늘어난다면 데이터 베이스가 과부하 될 수 있기 때문에 이때 캐시 서버를 도입하여 사용한다.  
그리고 이 캐시 서버로 이용할 수 있는 것이 바로 Redis다.

캐시는 한번 읽어온 데이터를 임의의 공간에 저장하여 다음에 읽을 때는 빠르게 결괏값을 받을 수 있도록 도와주는 공간이라 같은 요청이 여러 번 들어오는 경우 매번 데이터 베이스를 거치는 것이 아니라 캐시 서버에서 첫 번째 요청 이후 저장된 결괏값을 바로 내려주기 때문에 DB의 부하를 줄이고 서비스의 속도도 느려지지 않는 장점이 있다.


### Redis의 특징
- Key, Value 구조이기 때문에 쿼리를 사용할 필요가 없다.  
- 데이터를 디스크에 쓰는 구조가 아니라 메모리에서 데이터를 처리하기 때문에 속도가 빠르다.  
- String, Lists, Sets, Sorted Sets, Hashes 자료 구조를 지원한다.
   
    - String : 가장 일반적인 key - value 구조의 형태

    - Sets : String의 집합. 여러 개의 값을 하나의 value에 넣을 수 있다.

    - Sorted Sets : 중복된 데이터를 담지 않는 Set 구조에 정렬 Sort를 적용한 구조로 랭킹 보드 서버 같은 구현에 사용할 수 있다.

    - Lists : Array 형식의 데이터 구조. List를 사용하면 처음과 끝에 데이터를 넣고 빼는 건 빠르지만 중간에 데이터를 삽입하거나 삭제하는 것은 어렵다.

- Single Threaded 이다.  
  한 번에 하나의 명령만 처리할 수 있다. 그렇기 때문에 중간에 처리 시간이 긴 명령어가 들어오면 그 뒤에 명령어들은 모두 앞에 있는 명령어가 처리될 때까지 대기가 필요하다.  
  (하지만 get, set 명령어의 경우 초당 10만 개 이상 처리할 수 있을 만큼 빠르다.)
 
 

### Redis 사용시 주의할 점
- 서버에 장애가 발생했을 경우 그에 대한 운영 플랜이 꼭 필요하다.
    - 인메모리 데이터 저장소의 특성상, 서버에 장애가 발생했을 경우 데이터 유실이 발생할 수 있기 때문이다.
- 메모리 관리가 중요하다.
    - 싱글 스레드의 특성상, 한 번에 하나의 명령만 처리할 수 있기 때문에, 처리하는데 시간이 오래 걸리는 요청, 명령은 피해야 한다.
